﻿using System;
using System.ServiceModel;
using System.ServiceModel.Description;
using Microsoft.ServiceBus;
using ServiceBusUtils;
using EnergyServiceContract;

namespace NetEventRelayServer
{
 class Program
 {
  static void Main(string[] args)
  {
   try
   {
       string serviceNamespace = ServiceBusHelper.GetServiceBusSolutionName();
   

    string input = string.Empty;

    do
    {
     try
     {
      Console.WriteLine("Wpisz 'exit', aby zakończyć");
      Console.WriteLine("Podaj identyfikator gatewayId, aby wszystko wyłączyć");
      Console.Write("Podaj identyfikator GatewayID>");
      input = Console.ReadLine();
      TurnEverythingOff(serviceNamespace, input.Trim());
     }
     catch (Exception ex)
     {
      Console.WriteLine(ex.Message);

     }
        
    } while (input != "exit");

    
   }
   catch (Exception ex)
   {
    Console.WriteLine(ex.Message);

   }
  }

   static void TurnEverythingOff(string serviceNamespace, string gatewayId)
  {
      
      ChannelFactory<IEnergyServiceGatewayOperationsChannel> netTcpRelayChannelFactory = null;
      IEnergyServiceGatewayOperationsChannel netTcpRelayChannel = null;
      try
      {
          Uri serviceUri = ServiceBusEnvironment.CreateServiceUri("sb", serviceNamespace, ServiceBusHelper.GetGatewayServicePath(gatewayId));
          //For WS2207HttpRelayBinding
         // Uri serviceUri = ServiceBusEnvironment.CreateServiceUri("http", serviceNamespace, ServiceBusHelper.GetGatewayServicePath(gatewayId));

          netTcpRelayChannelFactory = new ChannelFactory<IEnergyServiceGatewayOperationsChannel>("RelayTcpEndpoint", new EndpointAddress(serviceUri));
          netTcpRelayChannel = netTcpRelayChannelFactory.CreateChannel();
          netTcpRelayChannel.Open();

          Console.WriteLine("Nawiązano połączenie z " + serviceUri.ToString());
          Console.WriteLine("Stan przełącznika oświetlenia:" + netTcpRelayChannel.GetLightingValue(gatewayId, "Lighting-1"));
          netTcpRelayChannel.SetLightingValue(gatewayId, "Lighting-1", 0);
          Console.WriteLine("Przełączono przełącznik oświetlenia do stanu OFF");

          Console.WriteLine("Bieżąca temperatura:" + netTcpRelayChannel.GetCurrentTemp(gatewayId, "HVAC-1"));
          Console.WriteLine("Bieżący punkt włączenia:" + netTcpRelayChannel.GetHVACSetpoint(gatewayId, "HVAC-1"));
          Console.WriteLine("Bieżący tryb HVAC:" + netTcpRelayChannel.GetHVACMode(gatewayId, "HVAC-1"));
          netTcpRelayChannel.SetHVACMode(gatewayId, "HVAC-1", 0);
          netTcpRelayChannel.SetHVACSetpoint(gatewayId, "HVAC-1", 78);
          Console.WriteLine("Ustawiono tryb urządzenia HVAC na OFF");
          Console.WriteLine("Ustawiono wszystkie urządzenia na OFF w lokalizacji: " + gatewayId);

      }
      catch (Exception ex)
      {
          Console.WriteLine(ex.Message);


      }
      finally
      {

          if (netTcpRelayChannel != null && netTcpRelayChannelFactory != null)
          {

              netTcpRelayChannel.Close();

              netTcpRelayChannelFactory.Close();

          }

      }

  }


 }
}
